//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) First Class Citizens
//:
//: Functions are "first class citizens", which means they can be stored as variables.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


func addOne(to number: Int) -> Int {
    number + 1
}

// store as a variable
let variable = addOne

// execute the function
variable(1)

// again and again
variable(1)
variable(1)


//:
//: -------------------
//:
//: The code above uses type inference to specify the type.
//:
//: When storing functions we must treat them in thier more purer form of a closure.
//:
//: Type annotation for closures can be a little confusing at first.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


func addTwo(to number: Int) -> Int {
    number + 2
}

// store as a variable
let variable2: (Int) -> Int = addOne

// execute
variable2(2)


//:
//: -------------------
//:
//: ## Task:
//:
//: The format for the type annotation of a closure is its "method signature".
//:
//: This is the type structure for the input and output.
//:
//: For example:
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// no input -> no output
func printHello() {
    print("Hello")
}
let variable4: () -> () = printHello
variable4()


// String input -> no output
func printText(_ text: String) {
    print("Hello")
}
let variable5: (String) -> () = printText
variable5("Hello")


// String, Int input -> no output
func printTextDetails(_ text: String, numberOfCharacters: Int) {
    print("Hello")
}
let variable6: (String, Int) -> () = printTextDetails
variable6("Hello", "Hello".count)


// String, Int input -> String output
func getTextDetails(_ text: String, numberOfCharacters: Int) -> String {
    "Hello" + " " + "\(numberOfCharacters)"
}
let variable7: (String, Int) -> String =  getTextDetails
print(variable7("Hello", "Hello".count))


//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, write a fizz buzz function.
//:
//: Store the function in a variable.
//:
//: Use the `map` function and pass this variable as input.
//:
//: The list of numbers is converted (or "mapped") into a list of fizzbuzzed strings.
//:
//: Print the list to the console.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: Copying the pattern below, write a function to generate a function that'll append a question mark to an input string.
//:
//: -------------------
//:


func generateAddExclamationFunction() -> ((String) -> String) {
    func addExclamation(to phrase: String) -> String {
        phrase + "!"
    }
    return addExclamation
}
let addExclamation: ((String) -> String) = generateAddExclamationFunction()
print(addExclamation("Wow"))
print(addExclamation("This is powerful"))
print(addExclamation("..and confusing"))


// write code here









